# nainstaluje kniznicu pre vyvodzovanie numerickych hodnot
install.packages( "fcm" )
library( fcm )
# nastavi working directory (adresar)
setwd( "~/R/fuzzy" )

## I. scenar - Zacinajuci portal - vysoka uroven investicii, ostatne koncepty nizke
scenar1.vec <- data.frame( 0.125,  0.125,  0.125,  0.125,  0.125, 0.875, 0.125, 0.125 )
## II. scenar - Zacinajuci portal - vysoka uroven atraktivneho obsahu, reputacie a mierna navstevnost
scenar2.vec <- data.frame( 0.875,  0.875,  0.125,  0.5,  0.125, 0.125, 0.125, 0.125 )
## III. scenar - Zabehnuty portal - kontroverzna strategia
scenar3.vec <- data.frame( 0.232,  0.125,  0.125,  0.248,  0.9, 0.25, 0.833, 0.125 )

# tu je mozne zmenit scenar (scenar1, scenar2, scenar3)
pociatocne_stavy.vec <- scenar1.vec
colnames( pociatocne_stavy.vec ) <- c( "K1", "K2", "K3", "K4", "K5", "K6", "K7", "K8" )
zavislosti.mat <- read.csv( "matica_zavislosti_ciselne.csv" )
ustaleny_stav <- fcm.infer( pociatocne_stavy.vec, zavislosti.mat, 15, "mk", "s", 3, 0.01 )
ustaleny_stav$values
library ( reshape2 )
library ( ggplot2 )
iterations <- as.numeric( rownames( ustaleny_stav$values ) )  # vytvorí vektor s císlami
df <- data.frame( iterations, ustaleny_stav$values )   # prida "iterations" do dataframeu "output1$values"
df2 <- melt(df, id="iterations")              # transformacia
ggplot(data=df2,                              # vykresli hodnoty konceptov po iteraciach do grafu
       aes( x=iterations, y=value, group=variable, colour=variable ) ) +
  theme_bw() + geom_line( size=0.7 ) + geom_point( size = 3 )