### Globalne premenne

## obor hodnot konceptov
slovne_hodnoty_konceptov <- list()
VN <- list(0, 0, 0.125)
slovne_hodnoty_konceptov[["VN"]] <- c( VN )
N <- list(0, 0.125, 0.25)
slovne_hodnoty_konceptov[["N"]] <- c( N )
SN <- list(0.125, 0.25, 0.375)
slovne_hodnoty_konceptov[["SN"]] <- c( SN )
MN <- list(0.25, 0.375, 0.5)
slovne_hodnoty_konceptov[["MN"]] <- c( MN )
M <- list(0.375, 0.5, 0.625)
slovne_hodnoty_konceptov[["M"]] <- c( M )
MV <- list(0.5, 0.625, 0.75)
slovne_hodnoty_konceptov[["MV"]] <- c( MV )
SV <- list(0.625, 0.75, 0.875)
slovne_hodnoty_konceptov[["SV"]] <- c( SV )
V <- list(0.75, 0.875, 1)
slovne_hodnoty_konceptov[["V"]] <- c( V )
VV <- list(0.875, 1, 1)
slovne_hodnoty_konceptov[["VV"]] <- c( VV )

## obor hodnot zavislosti (hran)
slovne_hodnoty_hran <- list()
VS <- list(0, 0, 0.125)
slovne_hodnoty_hran[["VS"]] <- c( VS )
S <- list(0, 0.125, 0.25)
slovne_hodnoty_hran[["S"]] <- c( S )
SS <- list(0.125, 0.25, 0.375)
slovne_hodnoty_hran[["SS"]] <- c( SS )
MS <- list(0.25, 0.375, 0.5)
slovne_hodnoty_hran[["MS"]] <- c( MS )
M <- list(0.375, 0.5, 0.625)
slovne_hodnoty_hran[["M"]] <- c( M )
MV <- list(0.5, 0.625, 0.75)
slovne_hodnoty_hran[["MV"]] <- c( MV )
SV <- list(0.625, 0.75, 0.875)
slovne_hodnoty_hran[["SV"]] <- c( SV )
V <- list(0.75, 0.875, 1)
slovne_hodnoty_hran[["V"]] <- c( V )
VV <- list(0.875, 1, 1)
slovne_hodnoty_hran[["VV"]] <- c( VV )
VS <- list(0, 0, -0.125)
slovne_hodnoty_hran[["NEGVS"]] <- c( VS )
S <- list(0, -0.125, -0.25)
slovne_hodnoty_hran[["NEGS"]] <- c( S )
SS <- list(-0.125, -0.25, -0.375)
slovne_hodnoty_hran[["NEGSS"]] <- c( SS )
MS <- list(-0.25, -0.375, -0.5)
slovne_hodnoty_hran[["NEGMS"]] <- c( MS )
M <- list(-0.375, -0.5, -0.625)
slovne_hodnoty_hran[["NEGM"]] <- c( M )
MV <- list(-0.5, -0.625, -0.75)
slovne_hodnoty_hran[["NEGMV"]] <- c( MV )
SV <- list(-0.625, -0.75, -0.875)
slovne_hodnoty_hran[["NEGSV"]] <- c( SV )
V <- list(-0.75, -0.875, -1)
slovne_hodnoty_hran[["NEGV"]] <- c( V )
VV <- list(-0.875, -1, -1)
slovne_hodnoty_hran[["NEGVV"]] <- c( VV )


### Definicie funkcii

## Vrati produkt dvoch trojuholnikovych cisiel
# list trojuholnikove cislo
# list trojuholnikove cislo
vynasobCisla <- function( trin_a, trin_b ) {
  trin_13 <- list()
  a <- list( trin_a[[1]][[1]], trin_a[[1]][[2]], trin_a[[1]][[3]] )
  b <- list( trin_b[[1]][[1]], trin_b[[1]][[2]], trin_b[[1]][[3]] )
  # vsetky kombinacie dolneho a horneho ohranicenia
  trin_13 <- c( trin_13, a[[1]] * b[[1]] )
  trin_13 <- c( trin_13, a[[1]] * b[[3]] )
  trin_13 <- c( trin_13, a[[3]] * b[[1]] )
  trin_13 <- c( trin_13, a[[3]] * b[[3]] )
  trin_2 <- a[[2]] * b[[2]] #stred
  # nove cislo je min(DxH), S*S, max(DxH)
  nove_cislo <- list(  min( unlist( trin_13 ) ), trin_2,  max( unlist( trin_13 ) ) )
  return( nove_cislo )
}


## Scita vsetky fuzzy cisla v liste
# list trojuholnikovych cisiel
scitajCisla <- function( cisla ) {
  scitanec = list(0, 0, 0) # zadefinuje prazdne fuzzy cislo
  for ( cislo in cisla ) {
    scitanec[[1]] <- scitanec[[1]] + cislo[[1]]
    scitanec[[2]] <- scitanec[[2]] + cislo[[2]]
    scitanec[[3]] <- scitanec[[3]] + cislo[[3]]
  }
  if ( scitanec[[1]] > 1 ) {
    scitanec[[1]] <- 1
  }
  if ( scitanec[[2]] > 1 ) {
    scitanec[[2]] <- 1
  }
  if ( scitanec[[3]] > 1 ) {
    scitanec[[3]] <- 1
  }
  return( scitanec )
}


## Vrati slovnu hodnotu konceptu
# list trojuholnikove cislo
konceptSlovnePodlaRezidua <- function( trojuholnikove_cislo ) {

  deltas <- c()

  VN <- c(0, 0, 0.125)
  N <- c(0, 0.125, 0.25)
  SN <- c(0.125, 0.25, 0.375)
  MN <- c(0.25, 0.375, 0.5)
  M <- c(0.375, 0.5, 0.625)
  MV <- c(0.5, 0.625, 0.75)
  SV <- c(0.625, 0.75, 0.875)
  V <- c(0.75, 0.875, 1)
  VV <- c(0.875, 1, 1)

  koncepty.mat <- matrix( c(VN, N, SN, MN, M, MV, SV, V, VV ), nrow =18, ncol=3, byrow=TRUE )

  i <- 1
  while ( i <= 18 ) {
    koncept <- ( koncepty.mat[c(i), c(1,2,3)] )
    delta <- sqrt( 1/3 * (  ( trojuholnikove_cislo[[1]] - koncept[1])^2 + ( trojuholnikove_cislo[[2]] - koncept[2])^2 + ( trojuholnikove_cislo[[3]] - koncept[3])^2 ) )
    deltas[i] <- delta
    i <- i + 1
  }

  minimum = min( unlist( deltas ) )
  poradie = which.min( unlist( deltas ) ) # ktory koncept

  if ( poradie == 1 ) {
    nova_hodnota_konceptu = "VN"
  }
  if ( poradie == 2 ) {
    nova_hodnota_konceptu = "N"
  }
  if ( poradie == 3 ) {
    nova_hodnota_konceptu = "SN"
  }
  if ( poradie == 4 ) {
    nova_hodnota_konceptu = "MN"
  }
  if ( poradie == 5 ) {
    nova_hodnota_konceptu = "M"
  }
  if ( poradie == 6 ) {
    nova_hodnota_konceptu = "MV"
  }
  if ( poradie == 7 ) {
    nova_hodnota_konceptu = "SV"
  }
  if ( poradie == 8 ) {
    nova_hodnota_konceptu = "V"
  }
  if ( poradie == 9 ) {
    nova_hodnota_konceptu = "VV"
  }

  return( nova_hodnota_konceptu )

}


## vrati slovnu hodnotu vplyvu z oboru hodnot
# list trojuholnikove fuzzy cislo
vplyvSlovnePodlaRezidua <- function( scitanec_vplyvov ) {

  deltas <- c()

  NEGVV = c(-0.875, -1, -1)
  NEGV= c(-0.75, -0.875, -1)
  NEGSV = c(-0.625, -0.75, -0.875)
  NEGMV = c(-0.5, -0.625, -0.75)
  NEGM = c(-0.375, -0.5, -0.625)
  NEGMS = c(-0.25, -0.375, -0.5)
  NEGSS = c(-0.125, -0.25, -0.375)
  NEGS = c(0, -0.125, -0.25)
  NEGVS = c(0, 0, -0.125)
  VS = c(0, 0, 0.125)
  S = c(0, 0.125, 0.25)
  SS = c(0.125, 0.25, 0.375)
  MS = c(0.25, 0.375, 0.5)
  M = c(0.375, 0.5, 0.625)
  MV = c(0.5, 0.625, 0.75)
  SV = c(0.625, 0.75, 0.875)
  V = c(0.75, 0.875, 1)
  VV = c(0.875, 1, 1)

  zavislosti.mat <- matrix( c(NEGVV, NEGV, NEGSV, NEGMV, NEGM, NEGMS, NEGSS, NEGS, NEGVS, VS, S, SS, MS, M, MV, SV, V, VV ), nrow =18, ncol=3, byrow=TRUE )

  i <- 1
  while ( i <= 18 ) {
    zavislost <- ( zavislosti.mat[c(i), c(1,2,3)] )
    delta <- sqrt( 1/3 * (  ( scitanec_vplyvov[[1]] - zavislost[1] )^2 + ( scitanec_vplyvov[[2]] - zavislost[2] )^2 + ( scitanec_vplyvov[[3]] - zavislost[3])^2 ) )
    deltas[i] <- delta
    i <- i + 1
  }
  
  minimum = min( unlist( deltas ) )
  poradie = which.min( unlist( deltas ) ) # v kolkatej/ktorej hrane

  if ( poradie == 1 ) {
    hrana = "NEGVV"
  }
  if ( poradie == 2 ) {
    hrana = "NEGV"
  }
  if ( poradie == 3 ) {
    hrana = "NEGSV"
  }
  if ( poradie == 4 ) {
    hrana = "NEGMV"
  }
  if ( poradie == 5 ) {
    hrana = "NEGM"
  }
  if ( poradie == 6 ) {
    hrana = "NEGMS"
  }
  if ( poradie == 7 ) {
    hrana = "NEGSS"
  }
  if ( poradie == 8 ) {
    hrana = "NEGS"
  }
  if ( poradie == 9 ) {
    hrana = "NEGVS"
  }
  if ( poradie == 10 ) {
    hrana = "VS"
  }
  if ( poradie == 11 ) {
    hrana = "S"
  }
  if ( poradie == 12 ) {
    hrana = "SS"
  }
  if ( poradie == 13 ) {
    hrana = "MS"
  }
  if ( poradie == 14 ) {
    hrana = "M"
  }
  if ( poradie == 15 ) {
    hrana = "MV"
  }
  if ( poradie == 16 ) {
    hrana = "SV"
  }
  if ( poradie == 17 ) {
    hrana = "V"
  }
  if ( poradie == 18 ) {
    hrana = "VV"
  }

  return( hrana )

}


## Spocita dve slovne fuzzy cisla
# string slovna hodnota vplyvu
# string slovna hodnota konceptu
zapocitajVplyvDoKonceptu <- function( vplyv_slovne, koncept_slovne ) {

  nove_cislo <- list(0,0,0)
  nove_cislo[[1]] <- slovne_hodnoty_hran[vplyv_slovne][[1]][[1]] + slovne_hodnoty_konceptov[koncept_slovne][[1]][[1]]
  nove_cislo[[2]] <- slovne_hodnoty_hran[vplyv_slovne][[1]][[2]] + slovne_hodnoty_konceptov[koncept_slovne][[1]][[2]]
  nove_cislo[[3]] <- slovne_hodnoty_hran[vplyv_slovne][[1]][[3]] + slovne_hodnoty_konceptov[koncept_slovne][[1]][[3]]

  return( nove_cislo )

}


## Prahova funkcia pre trojuholnikove fuzzy cisla
# string slovna hodnota hrany
novaHodnotaKonceptu <- function( slovnaHodnotaHrany ) {
  koncept <- ""
  if ( slovnaHodnotaHrany == "NEGVV" ) {
    koncept <- "VN"
  }
  if ( slovnaHodnotaHrany == "NEGV" ) {
    koncept <- "N"
  }
  if ( slovnaHodnotaHrany == "NEGSV" ) {
    koncept <- "SN"
  }
  if ( slovnaHodnotaHrany == "NEGMV" ) {
    koncept <- "SN"
  }
  if ( slovnaHodnotaHrany == "NEGM" ) {
    koncept <- "SN"
  }
  if ( slovnaHodnotaHrany == "NEGMS" ) {
    koncept <- "SN"
  }
  if ( slovnaHodnotaHrany == "NEGSS" ) {
    koncept <- "MN"
  }
  if ( slovnaHodnotaHrany == "NEGS" ) {
    koncept <- "M"
  }
  if ( slovnaHodnotaHrany == "NEGVS" ) {
    koncept <- "M"
  }
  if ( slovnaHodnotaHrany == "VS" ) {
    koncept <- "MV"
  }
  if ( slovnaHodnotaHrany == "S" ) {
    koncept <- "MV"
  }
  if ( slovnaHodnotaHrany == "SS" ) {
    koncept <- "SV"
  }
  if ( slovnaHodnotaHrany == "MS" ) {
    koncept <- "SV"
  }
  if ( slovnaHodnotaHrany == "M" ) {
    koncept <- "SV"
  }
  if ( slovnaHodnotaHrany == "MV" ) {
    koncept <- "V"
  }
  if ( slovnaHodnotaHrany == "SV" ) {
    koncept <- "V"
  }
  if ( slovnaHodnotaHrany == "V" ) {
    koncept <- "VV"
  }
  if ( slovnaHodnotaHrany == "VV" ) {
    koncept <- "VV"
  }
  return( koncept )
}


## Vyvodi nove hodnoty vstupnych konceptov po zadany pocet iteracii
# string nazov suboru matice slovnych zavislosti
# list slovne hodnoty konceptov
# integer pocet iteracii
simuluj <- function( matica_zavislosti, koncepty_slovne, pocet_iteracii ) {

  hrany_slovne = read.csv( matica_zavislosti, sep="," )
  hrany_slovne <- as.matrix( hrany_slovne )

  ## premeni slovne hodnoty konceptov na fuzzy cisla
  koncepty <- list()
  for ( koncept in koncepty_slovne ) {
    koncepty <- c( koncepty, slovne_hodnoty_konceptov[koncept] )
  }
  
  print( paste("Počiatočné stavy konceptov: ", paste( shQuote( koncepty_slovne ), collapse=", " ) ) )

  ## premeni slovne hodnoty hran na fuzzy cisla
  hrany <- matrix( rep(list(), 3), nrow =8, ncol=8, byrow=TRUE )
  i = 1
  j = 1
  for ( r in 1:nrow( hrany_slovne ) ) {
    j <- 1
    for ( c in 1:ncol( hrany_slovne ) ) {
      if ( hrany_slovne[r,c] != "0" ) {
        hrany[ i, j ] <- slovne_hodnoty_hran[hrany_slovne[r,c]]
      } else {
        hrany[ i, j ] <- "NA"
      }
      j <- j + 1
    }
    i <- i + 1
  }
  
  
  iteracia <- 1
  while ( iteracia <= pocet_iteracii ) {

    # priradi trojuholnikove cisla podla slovnych hodnot konceptov
    koncepty <- list()
    for ( koncept in koncepty_slovne ) {
      koncepty <- c( koncepty, slovne_hodnoty_konceptov[koncept] )
    }

    nove_slovne_hodnoty_konceptov <- list("", "", "", "", "", "", "", "")

    poradie_konceptu <- 1 # poradie konceptu v cykle
    for ( koncept in koncepty_slovne ) {

      i <- 1
      vplyvy <- list()

      # pre kazdu zavislot vplyvajucu na koncept
      while ( i <= 8 ) {

        # ak existuje zavislost vplyvajuca na koncept
        if ( hrany[ i, poradie_konceptu ] != "NA" ) {

          # vplyvajuci koncept * hrana
          vplyv <- vynasobCisla( koncepty[i], hrany[ i, poradie_konceptu ] )
          # priradi trojuholnikove cislo do listu vplyvov
          vplyvy <- append( vplyvy, list( vplyv ) )

        }

        i <- i + 1

      }

      vysledny_vplyv = scitajCisla( vplyvy )
      #print("vplyv je")
      #print(vysledny_vplyv)

      vysledny_vplyv_slovne = vplyvSlovnePodlaRezidua( vysledny_vplyv )
      #print("vplyv slovne je")
      #print(vysledny_vplyv_slovne)

      nove_cislo_konceptu = zapocitajVplyvDoKonceptu( vysledny_vplyv_slovne, koncept )
      #print("nove cislo konceptu je")
      #print(nove_cislo_konceptu)

      novy_koncept_slovne <- konceptSlovnePodlaRezidua( nove_cislo_konceptu )
      #print("koncept slovne je")
      #print(novy_koncept_slovne)
      
      #print("**vypocet konceptu**")

      nove_slovne_hodnoty_konceptov[poradie_konceptu] <- novy_koncept_slovne

      poradie_konceptu <- poradie_konceptu + 1

    }

    koncepty_slovne <- nove_slovne_hodnoty_konceptov
    #print(nove_slovne_hodnoty_konceptov)
    print( paste( "Nové stavy konceptov:",  paste( shQuote( nove_slovne_hodnoty_konceptov ), collapse=", " ) ) )

    iteracia <- iteracia + 1

  }

  print( paste("Výsledné stavy konceptov: ", paste( shQuote( nove_slovne_hodnoty_konceptov ), collapse=", " ) ) )
  #return( nove_slovne_hodnoty_konceptov )

}
